<?php
require "conn.php";

// Function to generate unique serial
function generateUniqueSerial($conn) {
    do {
        $serial = substr(md5(uniqid(rand(), true)), 0, 10) . time();
        $check_query = "SELECT COUNT(*) as count FROM flour_mill_permits WHERE serial = ?";
        $stmt = mysqli_prepare($conn, $check_query);
        mysqli_stmt_bind_param($stmt, "s", $serial);
        mysqli_stmt_execute($stmt);
        $result = mysqli_stmt_get_result($stmt);
        $row = mysqli_fetch_assoc($result);
        mysqli_stmt_close($stmt);
    } while ($row['count'] > 0);
    return $serial;
}

// Fetch edit data if editing
$edit_challan = null;
if (isset($_GET['edit'])) {
    $edit_id = intval($_GET['edit']);
    $edit_query = "SELECT * FROM flour_mill_permits WHERE id = ?";
    $stmt = mysqli_prepare($conn, $edit_query);
    mysqli_stmt_bind_param($stmt, "i", $edit_id);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    $edit_challan = mysqli_fetch_assoc($result);
    mysqli_stmt_close($stmt);
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Debug POST data to file
    $debug_log = "=== DEBUG LOG ===\n";
    $debug_log .= "Time: " . date('Y-m-d H:i:s') . "\n";
    $debug_log .= "ALL POST DATA:\n" . print_r($_POST, true) . "\n";
    $debug_log .= "dispatch_province from POST: '" . (isset($_POST['dispatch_province']) ? $_POST['dispatch_province'] : 'NOT SET') . "'\n";
    $debug_log .= "buyerstreetaddress from POST: '" . (isset($_POST['buyerstreetaddress']) ? $_POST['buyerstreetaddress'] : 'NOT SET') . "'\n";
    file_put_contents('debug_challan.txt', $debug_log, FILE_APPEND);
    
    $challan_id = isset($_POST['challan_id']) ? intval($_POST['challan_id']) : 0;
    $serial = trim($_POST['serial']);
    $flour_mill_name = trim($_POST['flour_mill_name']);
    $permit_type = trim($_POST['permit_type']);
    $license_number = trim($_POST['license_number']);
    $agent_name = trim($_POST['agent_name']);
    $agent_cnic = trim($_POST['agent_cnic']);
    $agent_cell = trim($_POST['agent_cell']);
    $auto_fetched_date = $_POST['auto_fetched_date'];
    $auto_fetched_time = $_POST['auto_fetched_time'];
    $auto_generated_permit_no = trim($_POST['auto_generated_permit_no']);
    $validity_of_permit = $_POST['validity_of_permit'];
    $total_authorized_qty = isset($_POST['total_authorized_qty']) ? intval($_POST['total_authorized_qty']) : 0;
    $unit = trim($_POST['unit']);
    $qty_requested = isset($_POST['qty_requested']) ? intval($_POST['qty_requested']) : 0;
    $dispatch_province = isset($_POST['dispatch_province']) ? trim($_POST['dispatch_province']) : '';
    $dispatch_division = isset($_POST['dispatch_division']) ? trim($_POST['dispatch_division']) : '';
    $dispatch_district = isset($_POST['dispatch_district']) ? trim($_POST['dispatch_district']) : '';
    $balance_qty = isset($_POST['balance_qty']) ? intval($_POST['balance_qty']) : 0;
    $truck_number = trim($_POST['truck_number']);
    $drivers_name = trim($_POST['drivers_name']);
    $drivers_cnic = trim($_POST['drivers_cnic']);
    $drivers_mobno = trim($_POST['drivers_mobno']);
    $buyerstreetaddress = isset($_POST['buyerstreetaddress']) ? trim($_POST['buyerstreetaddress']) : '';
    $builty_number = isset($_POST['builty_number']) ? intval($_POST['builty_number']) : 0;
    $total_bags = isset($_POST['total_bags']) ? intval($_POST['total_bags']) : 0;
    $receipt_province = trim($_POST['receipt_province']);
    $receipt_division = trim($_POST['receipt_division']);
    $receipt_district = trim($_POST['receipt_district']);
    $qty_purchased = isset($_POST['qty_purchased']) ? intval($_POST['qty_purchased']) : 0;
    
    if ($challan_id > 0) {
// Update
$update_query = "UPDATE flour_mill_permits SET 
    serial = ?, 
    flour_mill_name = ?, 
    permit_type = ?, 
    license_number = ?, 
    agent_name = ?, 
    agent_cnic = ?, 
    agent_cell = ?, 
    auto_fetched_date = ?, 
    auto_fetched_time = ?, 
    auto_generated_permit_no = ?, 
    validity_of_permit = ?, 
    total_authorized_qty = ?, 
    unit = ?, 
    qty_requested = ?, 
    dispatch_province = ?, 
    dispatch_division = ?, 
    dispatch_district = ?, 
    balance_qty = ?, 
    truck_number = ?, 
    drivers_name = ?, 
    drivers_cnic = ?, 
    drivers_mobno = ?, 
    buyerstreetaddress = ?, 
    builty_number = ?, 
    total_bags = ?, 
    receipt_province = ?, 
    receipt_division = ?, 
    receipt_district = ?, 
    qty_purchased = ?
WHERE id = ?";

$stmt = mysqli_prepare($conn, $update_query);

mysqli_stmt_bind_param($stmt, "ssssssssssssssssssssssssssssss",
    $serial, $flour_mill_name, $permit_type, $license_number, $agent_name,
    $agent_cnic, $agent_cell, $auto_fetched_date, $auto_fetched_time,
    $auto_generated_permit_no, $validity_of_permit, $total_authorized_qty,
    $unit, $qty_requested, $dispatch_province, $dispatch_division,
    $dispatch_district, $balance_qty, $truck_number, $drivers_name,
    $drivers_cnic, $drivers_mobno, $buyerstreetaddress, $builty_number,
    $total_bags, $receipt_province, $receipt_division, $receipt_district,
    $qty_purchased, $challan_id);
       
        if (mysqli_stmt_execute($stmt)) {
            echo "<script>alert('Challan updated successfully!'); window.parent.location.href='dashboard.php';</script>";
            exit();
        } else {
            $error_msg = "Error updating challan: " . mysqli_error($conn);
            echo "<script>alert('$error_msg');</script>";
        }
    } else {
        // Insert
        $insert_query = "INSERT INTO flour_mill_permits (serial, flour_mill_name, permit_type, license_number, agent_name, agent_cnic, agent_cell, auto_fetched_date, auto_fetched_time, auto_generated_permit_no, validity_of_permit, total_authorized_qty, unit, qty_requested, dispatch_province, dispatch_division, dispatch_district, balance_qty, truck_number, drivers_name, drivers_cnic, drivers_mobno, buyerstreetaddress, builty_number, total_bags, receipt_province, receipt_division, receipt_district, qty_purchased, created_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())";
        $stmt = mysqli_prepare($conn, $insert_query);
        mysqli_stmt_bind_param($stmt, "sssssssssssssssssssssssssssss",
            $serial, $flour_mill_name, $permit_type, $license_number, $agent_name,
            $agent_cnic, $agent_cell, $auto_fetched_date, $auto_fetched_time,
            $auto_generated_permit_no, $validity_of_permit, $total_authorized_qty,
            $unit, $qty_requested, $dispatch_province, $dispatch_division,
            $dispatch_district, $balance_qty, $truck_number, $drivers_name,
            $drivers_cnic, $drivers_mobno, $buyerstreetaddress, $builty_number,
            $total_bags, $receipt_province, $receipt_division, $receipt_district,
            $qty_purchased);
       
        if (mysqli_stmt_execute($stmt)) {
            echo "<script>alert('Challan added successfully!'); window.parent.location.href='dashboard.php';</script>";
            exit();
        } else {
            $error_msg = "Error adding challan: " . mysqli_error($conn);
            echo "<script>alert('$error_msg');</script>";
        }
    }
    mysqli_stmt_close($stmt);
}

// Fetch mills for dropdown
$mills_query = "SELECT * FROM mills WHERE status='Active' ORDER BY mill_name";
$mills_result = mysqli_query($conn, $mills_query);

// Fetch agents for dropdown
$agents_query = "SELECT * FROM agents WHERE status='Active' ORDER BY agent_name";
$agents_result = mysqli_query($conn, $agents_query);

// Fetch drivers for dropdown
$drivers_query = "SELECT * FROM drivers WHERE status='Active' ORDER BY driver_name";
$drivers_result = mysqli_query($conn, $drivers_query);

// Generate serial for new challan
$generated_serial = $edit_challan ? $edit_challan['serial'] : generateUniqueSerial($conn);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>FDIMS :: <?php echo $edit_challan ? 'Edit' : 'Add New'; ?> Challan</title>
    <link rel="shortcut icon" href="assets/images/favicon.png">
    <link href="https://fonts.googleapis.com/css?family=Roboto:400,500,700&display=swap" rel="stylesheet">
    <link href="font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet">
    <link href="assets/css/bootstrap.min.css" rel="stylesheet" type="text/css">
    <link href="assets/css/style.css" rel="stylesheet" type="text/css">
    <link href="assets/css/custom.css" rel="stylesheet" type="text/css">
    <style>
        body {
            background: #f5f7fa;
            font-family: 'Roboto', sans-serif;
            padding: 20px;
        }
        .form-container {
            background: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            max-width: 1400px;
            margin: 0 auto;
        }
        .form-container h4 {
            color: #2c3e50;
            font-weight: 600;
            margin-bottom: 25px;
            padding-bottom: 15px;
            border-bottom: 3px solid #667eea;
        }
        .form-section-title {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 10px 20px;
            border-radius: 5px;
            margin-top: 25px;
            margin-bottom: 20px;
            font-weight: 600;
            font-size: 16px;
        }
        .form-control {
            border-radius: 5px;
            border: 1px solid #ced4da;
            padding: 10px 15px;
        }
        .form-control:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 0.2rem rgba(102,126,234,0.25);
        }
        .btn-submit {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 12px 40px;
            border-radius: 8px;
            font-weight: 500;
            border: none;
        }
        .btn-submit:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102,126,234,0.4);
            color: white;
        }
        .btn-reset {
            background: #6c757d;
            color: white;
            padding: 12px 40px;
            border-radius: 8px;
            font-weight: 500;
            border: none;
        }
        .alert {
            padding: 15px 20px;
            margin-bottom: 20px;
            border-radius: 8px;
            border-left: 4px solid;
        }
        .alert-success {
            background-color: #d4edda;
            border-left-color: #28a745;
            color: #155724;
        }
        .alert-danger {
            background-color: #f8d7da;
            border-left-color: #dc3545;
            color: #721c24;
        }
    </style>
</head>
<body>
    <div class="form-container">
        <h4>
            <i class="fa fa-file-text"></i> 
            <?php echo $edit_challan ? 'Edit Challan #' . $edit_challan['id'] : 'Add New Challan'; ?>
        </h4>

        <?php if (isset($error_msg)): ?>
            <div class="alert alert-danger">
                <i class="fa fa-exclamation-circle"></i> <?php echo htmlspecialchars($error_msg); ?>
            </div>
        <?php endif; ?>

        <form method="POST" action="challan_form.php<?php echo $edit_challan ? '?edit=' . $edit_challan['id'] : ''; ?>" id="challanForm">
            <?php if ($edit_challan): ?>
                <input type="hidden" name="challan_id" value="<?php echo $edit_challan['id']; ?>">
            <?php endif; ?>

            <!-- Serial Number -->
            <div class="row">
                <div class="col-md-12">
                    <div class="form-group">
                        <label>Serial Number <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="serial" id="serial"
                               value="<?php echo $generated_serial; ?>" required>
                        <small class="text-muted">Auto-generated unique serial (editable)</small>
                    </div>
                </div>
            </div>

            <!-- Mill Information Section -->
            <div class="form-section-title">
                <i class="fa fa-industry"></i> Mill Information
            </div>
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Select Mill</label>
                        <select class="form-control" id="mill_select">
                            <option value="">--Select Mill--</option>
                            <?php while ($mill = mysqli_fetch_assoc($mills_result)): ?>
                                <option value="<?php echo $mill['mill_id']; ?>"><?php echo htmlspecialchars($mill['mill_name']); ?></option>
                            <?php endwhile; ?>
                        </select>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Flour Mill Name <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="flour_mill_name" id="flour_mill_name"
                               value="<?php echo $edit_challan ? htmlspecialchars($edit_challan['flour_mill_name']) : ''; ?>" required>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Permit Type <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="permit_type" id="permit_type"
                               value="<?php echo $edit_challan ? htmlspecialchars($edit_challan['permit_type']) : ''; ?>" required>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <label>License Number <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="license_number" id="license_number"
                               value="<?php echo $edit_challan ? htmlspecialchars($edit_challan['license_number']) : ''; ?>" required>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Total Authorized Qty <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" name="total_authorized_qty" id="total_authorized_qty"
                               value="<?php echo $edit_challan ? $edit_challan['total_authorized_qty'] : ''; ?>" required>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Unit <span class="text-danger">*</span></label>
                        <select class="form-control" name="unit" id="unit" required>
                            <option value="Tons" <?php echo ($edit_challan && $edit_challan['unit'] == 'Tons') ? 'selected' : ''; ?>>Tons</option>
                            <option value="KG" <?php echo ($edit_challan && $edit_challan['unit'] == 'KG') ? 'selected' : ''; ?>>KG</option>
                            <option value="Bags" <?php echo ($edit_challan && $edit_challan['unit'] == 'Bags') ? 'selected' : ''; ?>>Bags</option>
                        </select>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Dispatch Province <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="dispatch_province" id="dispatch_province"
                               value="<?php echo $edit_challan ? htmlspecialchars($edit_challan['dispatch_province']) : ''; ?>" required>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Dispatch Division <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="dispatch_division" id="dispatch_division"
                               value="<?php echo $edit_challan ? htmlspecialchars($edit_challan['dispatch_division']) : ''; ?>" required>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Dispatch District <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="dispatch_district" id="dispatch_district"
                               value="<?php echo $edit_challan ? htmlspecialchars($edit_challan['dispatch_district']) : ''; ?>" required>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="form-group">
                        <label>Buyer Street Address <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="buyerstreetaddress" id="buyerstreetaddress"
                               value="<?php echo $edit_challan ? htmlspecialchars($edit_challan['buyerstreetaddress']) : ''; ?>" required>
                    </div>
                </div>
            </div>

            <!-- Agent Information Section -->
            <div class="form-section-title">
                <i class="fa fa-user"></i> Agent Information
            </div>
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Select Agent</label>
                        <select class="form-control" id="agent_select">
                            <option value="">--Select Agent--</option>
                            <?php while ($agent = mysqli_fetch_assoc($agents_result)): ?>
                                <option value="<?php echo $agent['agent_id']; ?>"><?php echo htmlspecialchars($agent['agent_name']); ?></option>
                            <?php endwhile; ?>
                        </select>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Agent Name <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="agent_name" id="agent_name"
                               value="<?php echo $edit_challan ? htmlspecialchars($edit_challan['agent_name']) : ''; ?>" required>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Agent CNIC <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="agent_cnic" id="agent_cnic"
                               value="<?php echo $edit_challan ? htmlspecialchars($edit_challan['agent_cnic']) : ''; ?>" required>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Agent Cell <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="agent_cell" id="agent_cell"
                               value="<?php echo $edit_challan ? htmlspecialchars($edit_challan['agent_cell']) : ''; ?>" required>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Recipient Province <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="receipt_province" id="receipt_province"
                               value="<?php echo $edit_challan ? htmlspecialchars($edit_challan['receipt_province']) : ''; ?>" required>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Recipient Division <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="receipt_division" id="receipt_division"
                               value="<?php echo $edit_challan ? htmlspecialchars($edit_challan['receipt_division']) : ''; ?>" required>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Recipient District <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="receipt_district" id="receipt_district"
                               value="<?php echo $edit_challan ? htmlspecialchars($edit_challan['receipt_district']) : ''; ?>" required>
                    </div>
                </div>
            </div>

            <!-- Date & Time Section -->
            <div class="form-section-title">
                <i class="fa fa-calendar"></i> Date & Time Information
            </div>
            <div class="row">
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Fetch Date <span class="text-danger">*</span></label>
                        <input type="date" class="form-control" name="auto_fetched_date" id="auto_fetched_date"
                               value="<?php echo $edit_challan ? $edit_challan['auto_fetched_date'] : date('Y-m-d'); ?>" required>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Fetch Time <span class="text-danger">*</span></label>
                        <input type="time" class="form-control" name="auto_fetched_time" id="auto_fetched_time"
                               value="<?php echo $edit_challan ? $edit_challan['auto_fetched_time'] : date('H:i'); ?>" required>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Auto Generated Permit No <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="auto_generated_permit_no" id="auto_generated_permit_no"
                               value="<?php echo $edit_challan ? htmlspecialchars($edit_challan['auto_generated_permit_no']) : ''; ?>" required>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Validity of Permit <span class="text-danger">*</span></label>
                        <input type="datetime-local" class="form-control" name="validity_of_permit" id="validity_of_permit"
                               value="<?php echo $edit_challan ? date('Y-m-d\TH:i', strtotime($edit_challan['validity_of_permit'])) : ''; ?>" required>
                    </div>
                </div>
            </div>

            <!-- Quantity Section -->
            <div class="form-section-title">
                <i class="fa fa-balance-scale"></i> Quantity Information
            </div>
            <div class="row">
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Quantity Requested <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" name="qty_requested" id="qty_requested"
                               value="<?php echo $edit_challan ? $edit_challan['qty_requested'] : ''; ?>" required>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Balance Qty <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" name="balance_qty" id="balance_qty"
                               value="<?php echo $edit_challan ? $edit_challan['balance_qty'] : ''; ?>" required>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Total Bags <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" name="total_bags" id="total_bags"
                               value="<?php echo $edit_challan ? $edit_challan['total_bags'] : ''; ?>" required>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Quantity Purchased <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" name="qty_purchased" id="qty_purchased"
                               value="<?php echo $edit_challan ? $edit_challan['qty_purchased'] : ''; ?>" required>
                    </div>
                </div>
            </div>

            <!-- Driver & Vehicle Information Section -->
            <div class="form-section-title">
                <i class="fa fa-truck"></i> Driver & Vehicle Information
            </div>
            <div class="row">
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Select Driver</label>
                        <select class="form-control" id="driver_select">
                            <option value="">--Select Driver--</option>
                            <?php while ($driver = mysqli_fetch_assoc($drivers_result)): ?>
                                <option value="<?php echo $driver['driver_id']; ?>"><?php echo htmlspecialchars($driver['driver_name']); ?></option>
                            <?php endwhile; ?>
                        </select>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Truck Number <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="truck_number" id="truck_number"
                               value="<?php echo $edit_challan ? htmlspecialchars($edit_challan['truck_number']) : ''; ?>" required>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Driver's Name <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="drivers_name" id="drivers_name"
                               value="<?php echo $edit_challan ? htmlspecialchars($edit_challan['drivers_name']) : ''; ?>" required>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Builty Number <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" name="builty_number" id="builty_number"
                               value="<?php echo $edit_challan ? $edit_challan['builty_number'] : ''; ?>" required>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label>Driver's CNIC <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="drivers_cnic" id="drivers_cnic"
                               value="<?php echo $edit_challan ? htmlspecialchars($edit_challan['drivers_cnic']) : ''; ?>" required>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label>Driver's Mobile <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="drivers_mobno" id="drivers_mobno"
                               value="<?php echo $edit_challan ? htmlspecialchars($edit_challan['drivers_mobno']) : ''; ?>" required>
                    </div>
                </div>
            </div>

            <!-- Submit Buttons -->
            <div class="form-group mt-4">
                <button type="submit" class="btn btn-submit">
                    <i class="fa fa-save"></i> <?php echo $edit_challan ? 'Update Challan' : 'Save Challan'; ?>
                </button>
                <button type="reset" class="btn btn-reset">
                    <i class="fa fa-refresh"></i> Reset
                </button>
            </div>
        </form>
    </div>

    <script src="assets/js/jquery.min.js"></script>
    <script src="assets/js/bootstrap.bundle.min.js"></script>
    <script>
        $(document).ready(function() {
            // Set default values on page load
            setDefaultValues();
            
            // Mill selection auto-fill
            $('#mill_select').change(function() {
                var mill_id = $(this).val();
                if (mill_id) {
                    $.ajax({
                        url: 'get_mill_data.php',
                        type: 'GET',
                        data: {mill_id: mill_id},
                        dataType: 'json',
                        success: function(data) {
                            $('#flour_mill_name').val(data.mill_name);
                            $('#permit_type').val(data.permit_type);
                            $('#license_number').val(data.license_number);
                            $('#total_authorized_qty').val(data.total_authorized_qty);
                            $('#unit').val(data.unit);
                            $('#dispatch_province').val(data.dispatch_province);
                            $('#dispatch_division').val(data.dispatch_division);
                            $('#dispatch_district').val(data.dispatch_district);
                            $('#buyerstreetaddress').val(data.street_address);
                            
                            // Get last balance for this mill
                            getLastBalanceForMill(data.mill_name);
                        }
                    });
                }
            });

            // Agent selection auto-fill
            $('#agent_select').change(function() {
                var agent_id = $(this).val();
                if (agent_id) {
                    $.ajax({
                        url: 'get_agent_data.php',
                        type: 'GET',
                        data: {agent_id: agent_id},
                        dataType: 'json',
                        success: function(data) {
                            $('#agent_name').val(data.agent_name);
                            $('#agent_cnic').val(data.agent_cnic);
                            $('#agent_cell').val(data.agent_cell);
                            $('#receipt_province').val(data.recipient_province);
                            $('#receipt_division').val(data.recipient_division);
                            $('#receipt_district').val(data.recipient_district);
                        }
                    });
                }
            });

            // Driver selection auto-fill
            $('#driver_select').change(function() {
                var driver_id = $(this).val();
                var driver_name = $('#driver_select option:selected').text();
                if (driver_id) {
                    $.ajax({
                        url: 'get_driver_data.php',
                        type: 'GET',
                        data: {driver_id: driver_id},
                        dataType: 'json',
                        success: function(data) {
                            $('#drivers_name').val(data.driver_name);
                            $('#drivers_cnic').val(data.driver_cnic);
                            $('#drivers_mobno').val(data.driver_mobno);
                        }
                    });
                    
                    // Get last truck number for this driver
                    $.ajax({
                        url: 'get_last_truck.php',
                        type: 'GET',
                        data: {driver_name: driver_name},
                        dataType: 'json',
                        success: function(data) {
                            if (data.truck_number) {
                                $('#truck_number').val(data.truck_number);
                            }
                        }
                    });
                }
            });
            
            // Auto-calculate validity of permit when fetch date/time changes
            $('#auto_fetched_date, #auto_fetched_time').change(function() {
                calculateValidityOfPermit();
            });
            
            // Auto-calculate balance qty when total authorized or qty requested changes
            $('#total_authorized_qty, #qty_requested').on('input change', function() {
                calculateBalanceQty();
                calculateTotalBags();
            });
            
            // Sync qty_requested to qty_purchased
            $('#qty_requested').on('input change', function() {
                $('#qty_purchased').val($(this).val());
            });
            
            // Function to set default values
            function setDefaultValues() {
                // Set current date and time
                var now = new Date();
                var date = now.toISOString().split('T')[0];
                var time = now.toTimeString().slice(0, 5);
                
                if (!$('#auto_fetched_date').val()) {
                    $('#auto_fetched_date').val(date);
                }
                if (!$('#auto_fetched_time').val()) {
                    $('#auto_fetched_time').val(time);
                }
                
                // Calculate validity of permit (71 hours 30 minutes from fetch date/time)
                calculateValidityOfPermit();
                
                // Get last permit number and add 10
                $.ajax({
                    url: 'get_last_permit.php',
                    type: 'GET',
                    dataType: 'json',
                    success: function(data) {
                        if (data.last_permit) {
                            var nextPermit = parseInt(data.last_permit) + 10;
                            $('#auto_generated_permit_no').val(nextPermit);
                        }
                    }
                });
                
                // Set default quantity requested and purchased to 40
                if (!$('#qty_requested').val()) {
                    $('#qty_requested').val(40);
                    $('#qty_purchased').val(40);
                }
                
                // Set default builty number
                if (!$('#builty_number').val()) {
                    $('#builty_number').val(0);
                }
            }
            
            // Function to calculate validity of permit (add 71 hours 30 minutes)
            function calculateValidityOfPermit() {
                var fetchDate = $('#auto_fetched_date').val();
                var fetchTime = $('#auto_fetched_time').val();
                
                if (fetchDate && fetchTime) {
                    var dateTime = new Date(fetchDate + 'T' + fetchTime);
                    // Add 71 hours and 30 minutes
                    dateTime.setHours(dateTime.getHours() + 71);
                    dateTime.setMinutes(dateTime.getMinutes() + 30);
                    
                    // Format for datetime-local input
                    var year = dateTime.getFullYear();
                    var month = String(dateTime.getMonth() + 1).padStart(2, '0');
                    var day = String(dateTime.getDate()).padStart(2, '0');
                    var hours = String(dateTime.getHours()).padStart(2, '0');
                    var minutes = String(dateTime.getMinutes()).padStart(2, '0');
                    
                    var validityDateTime = year + '-' + month + '-' + day + 'T' + hours + ':' + minutes;
                    $('#validity_of_permit').val(validityDateTime);
                }
            }
            
            // Function to get last balance for selected mill
            function getLastBalanceForMill(millName) {
                $.ajax({
                    url: 'get_last_balance.php',
                    type: 'GET',
                    data: {mill_name: millName},
                    dataType: 'json',
                    success: function(data) {
                        // Store last balance in a data attribute for calculation
                        $('#balance_qty').attr('data-last-balance', data.last_balance || 0);
                        // Trigger calculation
                        calculateBalanceQty();
                    }
                });
            }
            
            // Function to calculate balance quantity
            function calculateBalanceQty() {
                var lastBalance = parseInt($('#balance_qty').attr('data-last-balance')) || 0;
                var qtyRequested = parseInt($('#qty_requested').val()) || 0;
                
                // If we have last balance from same mill, use it; otherwise use total authorized
                if (lastBalance > 0) {
                    var balance = lastBalance - qtyRequested;
                } else {
                    var totalAuthorized = parseInt($('#total_authorized_qty').val()) || 0;
                    var balance = totalAuthorized - qtyRequested;
                }
                
                $('#balance_qty').val(balance);
            }
            
            // Function to calculate total bags (qty_requested * 1000 / 50)
            function calculateTotalBags() {
                var qtyRequested = parseInt($('#qty_requested').val()) || 0;
                var totalBags = Math.round((qtyRequested * 1000) / 50);
                $('#total_bags').val(totalBags);
            }
        });
    </script>
</body>
</html>
