<?php
require "conn.php";

// Get current section
$section = isset($_GET['section']) ? $_GET['section'] : 'dashboard';

// Pagination setup
$records_per_page = 25;
$page = isset($_GET['page']) ? intval($_GET['page']) : 1;
$offset = ($page - 1) * $records_per_page;

// Handle Delete
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $delete_query = "DELETE FROM flour_mill_permits WHERE id = ?";
    $stmt = mysqli_prepare($conn, $delete_query);
    mysqli_stmt_bind_param($stmt, "i", $id);
    
    if (mysqli_stmt_execute($stmt)) {
        $success_msg = "Challan deleted successfully!";
    } else {
        $error_msg = "Error deleting challan: " . mysqli_error($conn);
    }
    mysqli_stmt_close($stmt);
}

// Get total records for pagination
$count_query = "SELECT COUNT(*) as total FROM flour_mill_permits";
$count_result = mysqli_query($conn, $count_query);
$count_row = mysqli_fetch_assoc($count_result);
$total_records = $count_row['total'];
$total_pages = ceil($total_records / $records_per_page);

// Fetch challans with pagination
$challans_query = "SELECT * FROM flour_mill_permits ORDER BY id DESC LIMIT ? OFFSET ?";
$stmt = mysqli_prepare($conn, $challans_query);
mysqli_stmt_bind_param($stmt, "ii", $records_per_page, $offset);
mysqli_stmt_execute($stmt);
$challans_result = mysqli_stmt_get_result($stmt);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>FDIMS :: Dashboard</title>
    <link rel="shortcut icon" href="assets/images/favicon.png">
    <link href="https://fonts.googleapis.com/css?family=Roboto:400,500,700&display=swap" rel="stylesheet">
    <link href="font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet">
    <link href="assets/css/bootstrap.min.css" rel="stylesheet" type="text/css">
    <link href="assets/css/style.css" rel="stylesheet" type="text/css">
    <link href="assets/css/custom.css" rel="stylesheet" type="text/css">
    <style>
        body {
            background: #f5f7fa;
            font-family: 'Roboto', sans-serif;
        }
        .navbar-custom {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 15px 0;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .navbar-brand {
            display: flex;
            align-items: center;
            color: white !important;
            font-weight: 600;
            font-size: 20px;
        }
        .navbar-brand img {
            height: 40px;
            margin-right: 15px;
        }
        .navbar-nav .nav-link {
            color: white !important;
            padding: 10px 20px;
            margin: 0 5px;
            border-radius: 5px;
            transition: all 0.3s ease;
            font-weight: 500;
        }
        .navbar-nav .nav-link:hover {
            background: rgba(255,255,255,0.2);
            transform: translateY(-2px);
        }
        .navbar-nav .nav-link.active {
            background: rgba(255,255,255,0.3);
        }
        .container-fluid {
            padding: 30px;
        }
        .page-header {
            background: white;
            padding: 25px;
            border-radius: 10px;
            margin-bottom: 30px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            display: flex;
            align-items: center;
            justify-content: space-between;
        }
        .logo-section {
            display: flex;
            align-items: center;
        }
        .logo-section img {
            height: 60px;
            margin-right: 20px;
        }
        .logo-text h3 {
            margin: 0;
            color: #2c3e50;
            font-weight: 600;
            font-size: 24px;
        }
        .logo-text h3 span {
            display: block;
            font-size: 14px;
            color: #7f8c8d;
            font-weight: 400;
        }
        .btn-add-challan {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 12px 30px;
            border-radius: 8px;
            font-weight: 500;
            border: none;
            transition: all 0.3s ease;
        }
        .btn-add-challan:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102,126,234,0.4);
            color: white;
        }
        .table-container {
            background: white;
            padding: 25px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        }
        .table-container h4 {
            color: #2c3e50;
            font-weight: 600;
            margin-bottom: 20px;
            padding-bottom: 15px;
            border-bottom: 2px solid #667eea;
        }
        .table {
            font-size: 13px;
        }
        .table thead th {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            padding: 12px 8px;
            font-weight: 600;
            text-transform: uppercase;
            font-size: 11px;
            letter-spacing: 0.5px;
            vertical-align: middle;
            text-align: center;
        }
        .table tbody td {
            padding: 10px 8px;
            vertical-align: middle;
            border-color: #e9ecef;
            text-align: center;
            font-size: 12px;
        }
        .table tbody tr {
            transition: all 0.3s ease;
        }
        .table tbody tr:hover {
            background-color: #f8f9fa;
            transform: scale(1.005);
        }
        .btn-action {
            padding: 5px 12px;
            font-size: 11px;
            font-weight: 500;
            border-radius: 4px;
            transition: all 0.3s ease;
            border: none;
            min-width: 60px;
            display: inline-block;
            text-align: center;
            margin: 2px;
        }
        .btn-action:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.2);
        }
        .btn-sm.btn-info {
            background-color: #17a2b8;
            color: white;
        }
        .btn-sm.btn-danger {
            background-color: #dc3545;
            color: white;
        }
        .pagination-container {
            margin-top: 20px;
            display: flex;
            justify-content: center;
        }
        .pagination {
            display: flex;
            list-style: none;
            padding: 0;
            gap: 5px;
        }
        .pagination li {
            display: inline-block;
        }
        .pagination a {
            padding: 8px 15px;
            background: white;
            border: 1px solid #dee2e6;
            color: #667eea;
            text-decoration: none;
            border-radius: 5px;
            transition: all 0.3s ease;
        }
        .pagination a:hover {
            background: #667eea;
            color: white;
            transform: translateY(-2px);
        }
        .pagination .active a {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border-color: #667eea;
        }
        .pagination .disabled a {
            color: #6c757d;
            pointer-events: none;
            background: #f8f9fa;
        }
        .alert {
            padding: 15px 20px;
            margin-bottom: 20px;
            border-radius: 8px;
            border-left: 4px solid;
        }
        .alert-success {
            background-color: #d4edda;
            border-left-color: #28a745;
            color: #155724;
        }
        .alert-danger {
            background-color: #f8d7da;
            border-left-color: #dc3545;
            color: #721c24;
        }
        .action-buttons {
            white-space: nowrap;
        }
    </style>
</head>
<body>
    <!-- Navigation Bar -->
    <nav class="navbar navbar-expand-lg navbar-custom">
        <div class="container-fluid">
            <a class="navbar-brand" href="dashboard.php">
                <img src="assets/images/Logo-small.png" alt="Logo">
                FDIMS
            </a>
            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ml-auto">
                    <li class="nav-item">
                        <a class="nav-link active" href="dashboard.php">
                            <i class="fa fa-dashboard"></i> Dashboard
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="dashboard.php?section=mills">
                            <i class="fa fa-industry"></i> Manage Mills
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="dashboard.php?section=agents">
                            <i class="fa fa-users"></i> Manage Agents
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="dashboard.php?section=drivers">
                            <i class="fa fa-car"></i> Manage Drivers
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="dashboard.php?section=challan">
                            <i class="fa fa-plus-circle"></i> Add New Challan
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <div class="container-fluid">
        <!-- Page Header -->
        <div class="page-header">
            <div class="logo-section">
                <img src="assets/images/Logo-small.png" alt="Logo">
                <div class="logo-text">
                    <h3>Flour Ledger<span>Management System</span></h3>
                </div>
            </div>
            <a href="dashboard.php?section=challan" class="btn btn-add-challan">
                <i class="fa fa-plus"></i> Add New Challan
            </a>
        </div>

        <?php if (isset($success_msg)): ?>
            <div class="alert alert-success">
                <i class="fa fa-check-circle"></i> <?php echo htmlspecialchars($success_msg); ?>
            </div>
        <?php endif; ?>

        <?php if (isset($error_msg)): ?>
            <div class="alert alert-danger">
                <i class="fa fa-exclamation-circle"></i> <?php echo htmlspecialchars($error_msg); ?>
            </div>
        <?php endif; ?>

        <!-- Content Section -->
        <?php if ($section == 'dashboard'): ?>
            <!-- Challans Table -->
            <div class="table-container">
                <h4><i class="fa fa-list"></i> All Challans (Total: <?php echo $total_records; ?>)</h4>
            <div class="table-responsive">
                <table class="table table-bordered table-hover">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Serial</th>
                            <th>Mill Name</th>
                            <th>Permit Type</th>
                            <th>Agent Name</th>
                            <th>Truck Number</th>
                            <th>Driver Name</th>
                            <th>Qty Requested</th>
                            <th>Dispatch District</th>
                            <th>Receipt District</th>
                            <th>Created</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (mysqli_num_rows($challans_result) > 0): ?>
                            <?php while ($challan = mysqli_fetch_assoc($challans_result)): ?>
                                <tr>
                                    <td><?php echo $challan['id']; ?></td>
                                    <td><?php echo htmlspecialchars($challan['serial']); ?></td>
                                    <td><?php echo htmlspecialchars($challan['flour_mill_name']); ?></td>
                                    <td><?php echo htmlspecialchars($challan['permit_type']); ?></td>
                                    <td><?php echo htmlspecialchars($challan['agent_name']); ?></td>
                                    <td><?php echo htmlspecialchars($challan['truck_number']); ?></td>
                                    <td><?php echo htmlspecialchars($challan['drivers_name']); ?></td>
                                    <td><?php echo number_format($challan['qty_requested']) . ' ' . htmlspecialchars($challan['unit']); ?></td>
                                    <td><?php echo htmlspecialchars($challan['dispatch_district']); ?></td>
                                    <td><?php echo htmlspecialchars($challan['receipt_district']); ?></td>
                                    <td><?php echo date('d-m-Y', strtotime($challan['created_at'])); ?></td>
                                    <td class="action-buttons">
                                        <a href="index1.php?a=<?php echo urlencode($challan['serial']); ?>" 
                                           class="btn btn-sm btn-success btn-action"
                                           title="Print Challan"
                                           target="_blank">
                                            <i class="fa fa-print"></i> Print
                                        </a>
                                        <a href="challan_form.php?edit=<?php echo $challan['id']; ?>" 
                                           class="btn btn-sm btn-info btn-action"
                                           title="Edit Challan">
                                            <i class="fa fa-edit"></i> Edit
                                        </a>
                                        <a href="dashboard.php?delete=<?php echo $challan['id']; ?>&page=<?php echo $page; ?>" 
                                           class="btn btn-sm btn-danger btn-action"
                                           title="Delete Challan"
                                           onclick="return confirm('Are you sure you want to delete this challan?');">
                                            <i class="fa fa-trash"></i> Delete
                                        </a>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="12" class="text-center">No challans found. Add your first challan using the button above.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <?php if ($total_pages > 1): ?>
                <div class="pagination-container">
                    <ul class="pagination">
                        <li class="<?php echo ($page <= 1) ? 'disabled' : ''; ?>">
                            <a href="<?php echo ($page > 1) ? 'dashboard.php?page=' . ($page - 1) : '#'; ?>">
                                <i class="fa fa-chevron-left"></i> Previous
                            </a>
                        </li>
                        
                        <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                            <?php if ($i == 1 || $i == $total_pages || ($i >= $page - 2 && $i <= $page + 2)): ?>
                                <li class="<?php echo ($i == $page) ? 'active' : ''; ?>">
                                    <a href="dashboard.php?page=<?php echo $i; ?>"><?php echo $i; ?></a>
                                </li>
                            <?php elseif ($i == $page - 3 || $i == $page + 3): ?>
                                <li class="disabled"><a href="#">...</a></li>
                            <?php endif; ?>
                        <?php endfor; ?>
                        
                        <li class="<?php echo ($page >= $total_pages) ? 'disabled' : ''; ?>">
                            <a href="<?php echo ($page < $total_pages) ? 'dashboard.php?page=' . ($page + 1) : '#'; ?>">
                                Next <i class="fa fa-chevron-right"></i>
                            </a>
                        </li>
                    </ul>
                </div>
            <?php endif; ?>
            </div>
        <?php endif; ?>

        <?php if ($section == 'mills'): ?>
            <iframe src="mills_manage.php" style="width:100%; height:calc(100vh - 200px); border:none; border-radius:10px; box-shadow: 0 2px 10px rgba(0,0,0,0.05);"></iframe>
        <?php endif; ?>

        <?php if ($section == 'agents'): ?>
            <iframe src="agents_manage.php" style="width:100%; height:calc(100vh - 200px); border:none; border-radius:10px; box-shadow: 0 2px 10px rgba(0,0,0,0.05);"></iframe>
        <?php endif; ?>

        <?php if ($section == 'drivers'): ?>
            <iframe src="drivers_manage.php" style="width:100%; height:calc(100vh - 200px); border:none; border-radius:10px; box-shadow: 0 2px 10px rgba(0,0,0,0.05);"></iframe>
        <?php endif; ?>

        <?php if ($section == 'challan'): ?>
            <iframe src="challan_form.php" style="width:100%; height:calc(100vh - 200px); border:none; border-radius:10px; box-shadow: 0 2px 10px rgba(0,0,0,0.05);"></iframe>
        <?php endif; ?>
    </div>

    <script src="assets/js/jquery.min.js"></script>
    <script src="assets/js/bootstrap.bundle.min.js"></script>
    <script>
        // Update active nav link based on section
        $(document).ready(function() {
            var section = '<?php echo $section; ?>';
            $('.navbar-nav .nav-link').removeClass('active');
            if (section === 'dashboard') {
                $('.navbar-nav .nav-link[href="dashboard.php"]').addClass('active');
            } else {
                $('.navbar-nav .nav-link[href="dashboard.php?section=' + section + '"]').addClass('active');
            }
        });
    </script>
</body>
</html>
